<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\StreamerAwardHistory;


class StreamerAwardHistorySearch extends StreamerAwardHistory
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['position_number'], 'integer'],
            [['coin'], 'number'],
            [['position_number','coin'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
          return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = StreamerAwardHistory::find()
         ->orderBy(['created_at'=>SORT_DESC]);
        // add conditions that should always apply here

        
         
        

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
       $query->andFilterWhere([
            'coin' => $this->coin,
            'position_number' => $this->position_number
            
        ]);
       
       
      // $query->andFilterWhere(['like', 'user.name', $this->user_id]);
       

        return $dataProvider;
    }

   
    
}
