<?php

use yii\grid\GridView;
use yii\helpers\Html;

$this->title = 'Chat Messages';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="row">
    <div class="col-xs-12"><div class="box">
            <!-- /.box-header -->
            <div class="box-body">
                <div style="clear:both"></div>


                <?= GridView::widget([
                    'dataProvider' => $dataProvider,
                    'columns' => [
                        ['class' => 'yii\grid\SerialColumn'],
                        'id',
                        [
                            'attribute' => 'message',
                            'value' => function($data) {
                                return preg_replace('/[\x00-\x1F\x7F]/u', '', $data['message']);
                            }
                        ],
                        'room_id',
                        'delete_time',
                        'created_by',
                        'created_at:datetime',
                        [
                            'attribute'  => 'status',
                            'format'=>'raw'
                        ],
                        // [
						// 	'class' => 'yii\grid\ActionColumn',
						// 	 'header' => 'Action',
                        //      'template' => '{view}',
                        //  ],
                    
                    ],
                    'tableOptions' => [
                        'id' => 'theDatatable',
                        'class' => 'table table-striped table-bordered table-hover',
                    ],
                ]); ?>
            </div>


        </div>
        <!-- /.box -->



        <!-- /.col -->
    </div>
</div>