<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class DomainCertsContext extends InstanceContext {
    /**
     * Initialize the DomainCertsContext
     *
     * @param Version $version Version that contains the resource
     * @param string $domainSid Unique string used to identify the domain that this
     *                          certificate should be associated with.
     */
    public function __construct(Version $version, $domainSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['domainSid' => $domainSid, ];

        $this->uri = '/LinkShortening/Domains/' . \rawurlencode($domainSid) . '/Certificate';
    }

    /**
     * Update the DomainCertsInstance
     *
     * @param string $tlsCert Certificate and private key information for this
     *                        domain.
     * @return DomainCertsInstance Updated DomainCertsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(string $tlsCert): DomainCertsInstance {
        $data = Values::of(['TlsCert' => $tlsCert, ]);

        $payload = $this->version->update('POST', $this->uri, [], $data);

        return new DomainCertsInstance($this->version, $payload, $this->solution['domainSid']);
    }

    /**
     * Fetch the DomainCertsInstance
     *
     * @return DomainCertsInstance Fetched DomainCertsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): DomainCertsInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new DomainCertsInstance($this->version, $payload, $this->solution['domainSid']);
    }

    /**
     * Delete the DomainCertsInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Messaging.V1.DomainCertsContext ' . \implode(' ', $context) . ']';
    }
}